//+------------------------------------------------------------------+
//|                                           Fibonacci AI based.mq5 |
//|                                          Copyright 2023, Omegafx |
//|                 https://www.mql5.com/en/users/omegajoctan/seller |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omegafx"
#property link      "https://www.mql5.com/en/users/omegajoctan/seller"
#property version   "1.00"

#resource "\\Files\\EURUSD.PERIOD_H4.Fibonnacitarg-RFC.onnx" as uchar rfc_onnx[]
#resource "\\Files\\EURUSD.PERIOD_H4.Fibonnacitarg-RFR.onnx" as uchar rfr_onnx[]
#include <Random Forest.mqh>

CRandomForestClassifier rfc;
CRandomForestRegressor rfr;

#include <Trade\Trade.mqh>
#include <Trade\PositionInfo.mqh>

CTrade m_trade;
CPositionInfo m_position;

//---

input int magic_number = 12052025;
input int slippage = 100;
input string symbol_ = "EURUSD";
input ENUM_TIMEFRAMES timeframe_ = PERIOD_H4;
enum target_var_type
 {
   REGRESSOR,
   CLASSIFIER
 };

input group "Models configs";

input target_var_type fib_target = CLASSIFIER; //Model type
input int lookahead_window = 5;
input int lookback_window = 10;

int OldNumBars = -1;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Setting the symbol and timeframe
   
   if (!MQLInfoInteger(MQL_TESTER) && !MQLInfoInteger(MQL_DEBUG))
     if (!ChartSetSymbolPeriod(0, symbol_, timeframe_))
       {
         printf("%s failed to set symbol %s and timeframe %s",__FUNCTION__,symbol_,EnumToString(timeframe_));
         return INIT_FAILED;
       }

//---

   m_trade.SetExpertMagicNumber(magic_number);
   m_trade.SetDeviationInPoints(slippage);
   m_trade.SetMarginMode();
   m_trade.SetTypeFillingBySymbol(Symbol());
   
//---
   
   switch(fib_target)
     {
      case  REGRESSOR:
      
         if (!rfr.Init(rfr_onnx))
            {
               printf("%s failed to initialize the random forest regressor",__FUNCTION__);
               return INIT_FAILED;
            }
                    
        break;
      case CLASSIFIER:
            
         if (!rfc.Init(rfc_onnx))
            {
               printf("%s failed to initialize the random forest classifier",__FUNCTION__);
               return INIT_FAILED;
            }
            
        break;
     }

//---

   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- Getting signals from the model
   
   if (!isNewBar())
      return;
      
    vector x = {
       iOpen(Symbol(), Period(), 1),
       iHigh(Symbol(), Period(), 1),
       iLow(Symbol(), Period(), 1),
       iClose(Symbol(), Period(), 1)
    };
    
    long signal = 0;
    
    switch(fib_target)
      {
       case  REGRESSOR:
         {
            double pred_fib = rfr.predict(x);         
            signal = pred_fib>iClose(Symbol(), Period(), 0)?1:0; //If the predicted fibonacci is greater than the current close price, thats bullish otherwise thats bearish signal
         }
         
         break;
       case CLASSIFIER:
       
         signal = rfc.predict(x).cls;         
         
         break;
      }

//--- Trading based on the signals received from the model
   
   MqlTick ticks;
   if (!SymbolInfoTick(Symbol(), ticks))
      {
         printf("Failed to obtain ticks information, Error = %d",GetLastError());
         return;
      }
      
   double volume_ = SymbolInfoDouble(Symbol(), SYMBOL_VOLUME_MIN);
   
   if (signal == 1)
     {        
        if (!PosExists(POSITION_TYPE_BUY) && !PosExists(POSITION_TYPE_SELL))  
            m_trade.Buy(volume_, Symbol(), ticks.ask);
     }
     
   if (signal == 0)
     {        
        if (!PosExists(POSITION_TYPE_SELL) && !PosExists(POSITION_TYPE_BUY))  
             m_trade.Sell(volume_, Symbol(), ticks.bid);
     } 

//--- Closing trades 
   
   switch(fib_target)
     {
      case CLASSIFIER:
        
        CloseTradeAfterTime((Timeframe2Minutes(Period())*lookahead_window)*60); //Close the trade after a certain lookahead and according the the trained timeframe  
        
        break;
        
      case REGRESSOR:
      
        CloseTradeAfterTime((Timeframe2Minutes(Period())*lookback_window)*60); //Close the trade after a certain lookahead and according the the trained timeframe
        
        break;
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool isNewBar()
  {
   int CurrentNumBars = Bars(Symbol(), Period());
   if(OldNumBars!=CurrentNumBars)
     {
      OldNumBars = CurrentNumBars;
      return true;
     }
   return false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool PosExists(ENUM_POSITION_TYPE type)
 {
    for (int i=PositionsTotal()-1; i>=0; i--)
      if (m_position.SelectByIndex(i))
         if (m_position.Symbol()==Symbol() && m_position.Magic() == magic_number && m_position.PositionType()==type)
            return (true);
            
    return (false);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool ClosePos(ENUM_POSITION_TYPE type)
 {
    for (int i=PositionsTotal()-1; i>=0; i--)
      if (m_position.SelectByIndex(i))
         if (m_position.Symbol()==Symbol() && m_position.Magic() == magic_number && m_position.PositionType()==type)
            {
              if (m_trade.PositionClose(m_position.Ticket()))
                return true;
            }
            
    return (false);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CloseTradeAfterTime(int period_seconds)
{
   for (int i = PositionsTotal() - 1; i >= 0; i--)
      if (m_position.SelectByIndex(i))
         if (m_position.Magic() == magic_number)
            if (TimeCurrent() - m_position.Time() >= period_seconds)
               m_trade.PositionClose(m_position.Ticket(), slippage);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Timeframe2Minutes(ENUM_TIMEFRAMES tf)
{
   return int(PeriodSeconds(tf)/60.0);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
